package furny.ga.tuples;

/**
 * An immutable couple of two values.
 * 
 * @param <A>
 *          Type of valueA.
 * @param <B>
 *          Type of valueB.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class Couple<A, B> {
  private final A valueA;
  private final B valueB;

  /**
   * Creates a new couple.
   * 
   * @param valueA
   *          The value a.
   * @param valueB
   *          The value b.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public Couple(final A valueA, final B valueB) {
    this.valueA = valueA;
    this.valueB = valueB;
  }

  /**
   * Getter for valueA.
   * 
   * @return valueA.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public A getValueA() {
    return valueA;
  }

  /**
   * Getter for valueB.
   * 
   * @return valueB.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public B getValueB() {
    return valueB;
  }

  @Override
  public int hashCode() {
    return valueA.hashCode() ^ valueB.hashCode();
  }

  @Override
  public boolean equals(final Object o) {
    if (o == null || !(o instanceof Couple)) {
      return false;
    }

    final Couple<?, ?> pairo = (Couple<?, ?>) o;
    return this.valueA.equals(pairo.getValueA())
        && this.valueB.equals(pairo.getValueB());
  }
}
